//: c12:ShowMethods.java
// Zastosowanie odzwierciedlenia, aby pokaza wszystkie 
// metody klasy, nawet jeeli s one zdefiniowane w 
// klasie bazowej.
import java.lang.reflect.*;

public class ShowMethods {
  static final String usage =
    "Uycie: \n" +
    "ShowMethods nazwa.klasy\n" +
    "aby pokaza wszystkie metody z klasy lub: \n" +
    "ShowMethods nazwa.klasy sowo\n" +
    "aby poszuka metody o sygnaturze zawierajcej 'sowo'";
  public static void main(String[] args) {
    if(args.length < 1) {
      System.out.println(usage);
      System.exit(0);
    }
    try {
      Class c = Class.forName(args[0]);
      Method[] m = c.getMethods();
      Constructor[] ctor = c.getConstructors();
      if(args.length == 1) {
        for (int i = 0; i < m.length; i++)
          System.out.println(m[i]);
        for (int i = 0; i < ctor.length; i++)
          System.out.println(ctor[i]);
      } else {
        for (int i = 0; i < m.length; i++)
          if(m[i].toString()
             .indexOf(args[1])!= -1)
            System.out.println(m[i]);
        for (int i = 0; i < ctor.length; i++)
          if(ctor[i].toString()
             .indexOf(args[1])!= -1)
          System.out.println(ctor[i]);
      }
    } catch(ClassNotFoundException e) {
      System.err.println("Nie ma takiej klasy: " + e);
    }
  }
} ///:~
