//: c11:ZipCompress.java
// Wykorzystanie formatu Zip dla kompresji 
// dowolnej liczby plikw podanych z wiersza polece.
import java.io.*;
import java.util.*;
import java.util.zip.*;

public class ZipCompress {
  // Komunikaty wyjtkw wypisywane s na konsol:
  public static void main(String[] args) 
  throws IOException {
    FileOutputStream f =
      new FileOutputStream("test.zip");
    CheckedOutputStream csum =
      new CheckedOutputStream(
        f, new Adler32());
    ZipOutputStream out =
      new ZipOutputStream(
        new BufferedOutputStream(csum));
    out.setComment("Test Zipowania za pomoc Javy");
    // Nie ma odpowiadajcego getComment()
    for(int i = 0; i < args.length; i++) {
      System.out.println(
        "Zapis do pliku " + args[i]);
      BufferedReader in =
        new BufferedReader(
          new FileReader(args[i]));
      out.putNextEntry(new ZipEntry(args[i]));
      int c;
      while((c = in.read()) != -1)
        out.write(c);
      in.close();
    }
    out.close();
    // Suma kontrolna wana tylko po 
    // zamkniciu pliku!
    System.out.println("Suma kontrolna: " +
      csum.getChecksum().getValue());
    // Teraz rozpakowujemy pliki:
    System.out.println("Odczyt pliku");
    FileInputStream fi =
       new FileInputStream("test.zip");
    CheckedInputStream csumi =
      new CheckedInputStream(
        fi, new Adler32());
    ZipInputStream in2 =
      new ZipInputStream(
        new BufferedInputStream(csumi));
    ZipEntry ze;
    while((ze = in2.getNextEntry()) != null) {
      System.out.println("Odczytywanie pliku " + ze);
      int x;
      while((x = in2.read()) != -1)
        System.out.write(x);
    }
    System.out.println("Suma kontrolna: " +
      csumi.getChecksum().getValue());
    in2.close();
    // Alternatywny sposb otwierania 
    // i odczytu plikw zip:
    ZipFile zf = new ZipFile("test.zip");
    Enumeration e = zf.entries();
    while(e.hasMoreElements()) {
      ZipEntry ze2 = (ZipEntry)e.nextElement();
      System.out.println("Plik: " + ze2);
      // ... i ekstrakcja danych jak przedtem
    }
  }
} ///:~
