//: c11:Blip3.java
// Rekonstrukcja obiektw Externalizable.
import java.io.*;
import java.util.*;

public class Blip3 implements Externalizable {
  int i;
  String s; // Brak inicjalizacji
  public Blip3() {
    System.out.println("Konstruktor Blip3");
    // s, i nie zainicjowane
  }
  public Blip3(String x, int a) {
    System.out.println("Blip3(String x, int a)");
    s = x;
    i = a;
    // s & i inicjalizowane jedynie
    // w konstruktorze niedomylnym.
  }
  public String toString() { return s + i; }
  public void writeExternal(ObjectOutput out)
  throws IOException {
    System.out.println("Blip3.writeExternal");
    // To trzeba zrobi:
    out.writeObject(s); 
    out.writeInt(i);
  }
  public void readExternal(ObjectInput in)
  throws IOException, ClassNotFoundException {
    System.out.println("Blip3.readExternal");
    // To trzeba zrobi:
    s = (String)in.readObject(); 
    i =in.readInt();
  }
  public static void main(String[] args)
  throws IOException, ClassNotFoundException {
    System.out.println("Konstruowanie obiektw:");
    Blip3 b3 = new Blip3("String ", 47);
    System.out.println(b3);
    ObjectOutputStream o =
      new ObjectOutputStream(
        new FileOutputStream("Blip3.out"));
    System.out.println("Zapisywanie obiektu:");
    o.writeObject(b3);
    o.close();
    // Teraz chcemy go z powrotem:
    ObjectInputStream in =
      new ObjectInputStream(
        new FileInputStream("Blip3.out"));
    System.out.println("Odtwarzanie b3:");
    b3 = (Blip3)in.readObject();
    System.out.println(b3);
  }
} ///:~
