//: c06:FinalArguments.java
// Uycie "final" w argumentach metod.

class Gizmo {
  public void spin() {}
}

public class FinalArguments {
  void with(final Gizmo g) {
    //! g = new Gizmo(); // Niepoprawne -- g jest ostateczna
  }
  void without(Gizmo g) {
    g = new Gizmo(); // OK -- g nie jest ostateczna
    g.spin();
  }
  // void f(final int i) { i++; } // Nie mona zmieni
  // Mona jedynie odczyta warto zmiennej ostatecznej:
  int g(final int i) { return i + 1; }
  public static void main(String[] args) {
    FinalArguments bf = new FinalArguments();
    bf.without(null);
    bf.with(null);
  }
} ///:~
