//: c04:Garbage.java
// Pokaz odmiecacza 
// pamici i finalizacji

class Chair {
  static boolean gcrun = false;
  static boolean f = false;
  static int created = 0;
  static int finalized = 0;
  int i;
  Chair() {
    i = ++created;
    if(created == 47) 
      System.out.println("Obiekt 47");
  }
  public void finalize() {
    if(!gcrun) {
      // Wywoanie finalize() po raz pierwszy:
      gcrun = true;
      System.out.println(
        "Rozpoczcie finalizacji po stworzeniu " +
        created + " obiektw Chair");
    }
    if(i == 47) {
      System.out.println(
        "Finalizacja obiektu Chair #47, " +
        "Ustawienie znacznika zatrzymujcego tworzenie");
      f = true;
    }
    finalized++;
    if(finalized >= created)
      System.out.println(
        "Wszystkie " + finalized + " sfinalizowane");
  }
}

public class Garbage {
  public static void main(String[] args) {
    // Dopki znacznik nie jest ustawiony,
    // tworzymy obiekty Chair i String:
    while(!Chair.f) {
      new Chair();
      new String("Aby zabra troch miejsca");
    }
    System.out.println(
      "Po zakoczeniu tworzenia obiektw Chair:\n" +
      "liczba stworzonych obiektw = " + Chair.created +
      ", liczba sfinalizowanych = " + Chair.finalized);
    // Opcjonalne argumenty wymuszaj odmiecanie
    // pamici i finalizacj:
    if(args.length > 0) {
      if(args[0].equals("gc") || 
         args[0].equals("all")) {
        System.out.println("gc():");
        System.gc();
      }
      if(args[0].equals("finalize") || 
         args[0].equals("all")) {
        System.out.println("runFinalization():");
        System.runFinalization();
      }
    }
    System.out.println("cze!");
  }
} ///:~
