//: c04:DeathCondition.java
// Wykorzystanie finalize() do wykrycia obiektu, 
// ktry nie zosta waciwie zniszczony.

class Book {
  boolean checkedOut = false;
  Book(boolean checkOut) { 
    checkedOut = checkOut; 
  }
  void checkIn() {
    checkedOut = false;
  }
  public void finalize() {
    if(checkedOut)
      System.out.println("Bd: nadal checkedOut");
  }
}

public class DeathCondition {
  public static void main(String[] args) {
    Book novel = new Book(true);
    // Waciwe sprztanie:
    novel.checkIn();
    // Zgubienie referencji i zapomnienie o sprztaniu:
    new Book(true);
    // Wymuszenie odmiecania pamici i finalizacji:
    System.gc();
  }
} ///:~
