//: appendixa:CheckCloneable.java
// Sprawdzenie czy referencje mog by klonowane.

// Nie mona tego sklonowa, poniewa nie
// nadpisuje metody clone():
class Ordinary {}

// Przesonicie clone(), ale brak implementacji
// Cloneable:
class WrongClone extends Ordinary {
  public Object clone()
      throws CloneNotSupportedException {
    return super.clone(); // zgasza wyjtek
  }
}
// Wykonuje wszystkie waciwe dla klonowania dziaania:
class IsCloneable extends Ordinary 
implements Cloneable {
  public Object clone() 
      throws CloneNotSupportedException {
    return super.clone();
  }
}

// Wyczenie klonowania poprzez zgoszenie wyjtku:
class NoMore extends IsCloneable {
  public Object clone() 
      throws CloneNotSupportedException {
    throw new CloneNotSupportedException();
  }
}

class TryMore extends NoMore {
  public Object clone() 
      throws CloneNotSupportedException {
    // Wywoanie NoMore.clone() powoduje wyjtek:
    return super.clone();
  }
}

class BackOn extends NoMore {
  private BackOn duplicate(BackOn b) {
    // Jako zrobi a kopi b
    // i zwrci t kopi. Jest to kopia 
    // atrapa, tylko aby zobaczy:
    return new BackOn();
  }
  public Object clone() {
    // Nie wywouje NoMore.clone():
    return duplicate(this);
  }
}

// Nie mona z tego dziedziczy, a wic nie mona
// przesoni metody clone() tak jak w BackOn:
final class ReallyNoMore extends NoMore {}

public class CheckCloneable {
  static Ordinary tryToClone(Ordinary ord) {
    String id = ord.getClass().getName();
    Ordinary x = null;
    if(ord instanceof Cloneable) {
      try {
        System.out.println("Prba " + id);
        x = (Ordinary)((IsCloneable)ord).clone();
        System.out.println("Sklonowany " + id);
      } catch(CloneNotSupportedException e) {
        System.err.println("Nie mona sklonowa "+id);
      }
    }
    return x;
  }

  public static void main(String[] args) {
    // Rzutowanie w gr:
    Ordinary[] ord = { 
      new IsCloneable(),
      new WrongClone(),
      new NoMore(),
      new TryMore(),
      new BackOn(),
      new ReallyNoMore(),
    };
    Ordinary x = new Ordinary();
    // To si nie skompiluje, poniewa clone()
    // jest chroniona w Object:
    //! x = (Ordinary)x.clone();
    // tryToClone() najpierw sprawdza, czy
    // klasa implementuje Cloneable:
    for(int i = 0; i < ord.length; i++)
      tryToClone(ord[i]);
  }
} ///:~
