//: typeinfo/Staff.java
import java.util.*;

public class Staff extends ArrayList<Position> {
  public void add(String title, Person person) {
    add(new Position(title, person));
  }
  public void add(String... titles) {
    for(String title : titles)
      add(new Position(title));
  }
  public Staff(String... titles) { add(titles); }
  public boolean positionAvailable(String title) {
    for(Position position : this)
      if(position.getTitle().equals(title) &&
         position.getPerson() == Person.NULL)
        return true;
    return false;
  }	
  public void fillPosition(String title, Person hire) {
    for(Position position : this)
      if(position.getTitle().equals(title) &&
         position.getPerson() == Person.NULL) {
        position.setPerson(hire);
        return;
      }
    throw new RuntimeException(
      "Brak etatu " + title);
  }	
  public static void main(String[] args) {
    Staff staff = new Staff("Prezes", "Dyrektor zarzdzajcy",
      "Kierownik marketingu", "Kierownik produktu",
      "Szef projektu", "Programista",
      "Programista", "Programista",
      "Programista", "Tester",
      "Opiekun dokumentacji");
    staff.fillPosition("Prezes",
      new Person("Ja", "Pierwszy", "Szczyt szczytw"));
    staff.fillPosition("Szef projektu",
      new Person("Janina", "Staranna", "Przedmiecia"));
    if(staff.positionAvailable("Programista"))
      staff.fillPosition("Programista",
        new Person("Robert", "Koder", "Piwniczna"));
    System.out.println(staff);
  }
} /* Output:	
[Etat: Prezes Osoba: Ja Pierwszy Szczyt szczytw, Etat: Dyrektor zarzdzajcy NullPerson, Etat: Kierownik marketingu NullPerson, Etat: Kierownik produktu NullPerson, Etat: Szef projektu Osoba: Janina Staranna Przedmiecia, Etat: Programista Osoba: Robert Koder Piwniczna, Etat: Programista NullPerson, Etat: Programista NullPerson, Etat: Programista NullPerson, Etat: Tester NullPerson, Etat: Opiekun dokumentacji NullPerson]
*///:~
