//: typeinfo/InnerImplementation.java
// Prywatna klasa wewntrzna te nie ukryje si przed refleksj.
import typeinfo.interfacea.*;
import static net.mindview.util.Print.*;

class InnerA {
  private static class C implements A {
    public void f() { print("publiczna metoda C.f()"); }
    public void g() { print("publiczna metoda C.g()"); }
    void u() { print("pakietowa metoda C.u()"); }
    protected void v() { print("chroniona metoda C.v()"); }
    private void w() { print("prywatna metoda C.w()"); }
  }
  public static A makeA() { return new C(); }
}	

public class InnerImplementation {
  public static void main(String[] args) throws Exception {
    A a = InnerA.makeA();
    a.f();
    System.out.println(a.getClass().getName());
    // Refleksja i tak udostpni prywatn klas:
    HiddenImplementation.callHiddenMethod(a, "g");
    HiddenImplementation.callHiddenMethod(a, "u");
    HiddenImplementation.callHiddenMethod(a, "v");
    HiddenImplementation.callHiddenMethod(a, "w");
  }
} /* Output:
publiczna metoda C.f()
InnerA$C
publiczna metoda C.g()
pakietowa metoda C.u()
chroniona metoda C.v()
prywatna metoda C.w()
*///:~
