//: strings/TheReplacements.java
import java.util.regex.*;
import net.mindview.util.*;
import static net.mindview.util.Print.*;

/*! Oto blok tekstu, ktry zostanie wykorzystany
    jako cig wejciowy w operacjach na wyraeniach
    regularnych. Program w pierwszej kolejnoci
    pobierze zawarto bloku, poszukujc specjalnych
    ogranicznikw, a nastpnie wykorzysta j
    w dalszych operacjach !*/

public class TheReplacements {
  public static void main(String[] args) throws Exception {
    String s = TextFile.read("TheReplacements.java");
    // Dopasowanie powyszego komentarza bloku tekstu:
    Matcher mInput =
      Pattern.compile("/\\*!(.*)!\\*/", Pattern.DOTALL)
        .matcher(s);
    if(mInput.find())
      s = mInput.group(1); // Wyuskany przez grup w nawiasach
    // Zastpuje dwa lub wicej odstpw jednym znakiem odstpu:
    s = s.replaceAll(" {2,}", " ");
    // Usuwa wszelkie ostpy z pocztku wiersza
    // Koniecznie naley wykorzysta tryb MULTILINE:
    s = s.replaceAll("(?m)^ +", "");
    print(s);
    s = s.replaceFirst("[aeiou]", "(SAMOGOSKI1)");
    StringBuffer sbuf = new StringBuffer();
    Pattern p = Pattern.compile("[aeiou]");
    Matcher m = p.matcher(s);
    // Przetwarzanie informacji podczas realizacji
    // operacji zastpowania:
    while(m.find())
      m.appendReplacement(sbuf, m.group().toUpperCase());
    // Dodanie pozostaej czci cigu wejciowego:
    m.appendTail(sbuf);
    print(sbuf);
  }
} /* Output:
Oto blok tekstu, ktry zostanie wykorzystany
jako cig wejciowy w operacjach na wyraeniach
regularnych. Program w pierwszej kolejnoci
pobierze zawarto bloku, poszukujc specjalnych
ogranicznikw, a nastpnie wykorzysta j
w dalszych operacjach 
Ot(SAMOGOSKI1) blOk tEkstU, ktry zOstAnIE wykOrzystAny
jAkO cIg wEjcIOwy w OpErAcjAch nA wyrAEnIAch
rEgUlArnych. PrOgrAm w pIErwszEj kOlEjnOcI
pObIErzE zAwArtO blOkU, pOszUkUjc spEcjAlnych
OgrAnIcznIkw, A nAstpnIE wykOrzystA j
w dAlszych OpErAcjAch 
*///:~
