//: strings/TestRegularExpression.java
// Program pozwalajcy na atwe testowanie wyrae regularnych.
// {Args: abcabcabcdefabc "abc+" "(abc)+" "(abc){2,}" }
import java.util.regex.*;
import static net.mindview.util.Print.*;

public class TestRegularExpression {
  public static void main(String[] args) {
    if(args.length < 2) {
      print("Stosowanie:\njava TestRegularExpression " +
        "ciagznakw wyraenieregularne+");
      System.exit(0);
    }
    print("Wejcie: \"" + args[0] + "\"");
    for(String arg : args) {
      print("Wyraenie regularne: \"" + arg + "\"");
      Pattern p = Pattern.compile(arg);
      Matcher m = p.matcher(args[0]);
      while(m.find()) {
        print("Dopasowanie \"" + m.group() + "\" na pozycjach " +
          m.start() + "-" + (m.end() - 1));
      }
    }
  }
} /* Output:
Wejcie: "abcabcabcdefabc"
Wyraenie regularne: "abcabcabcdefabc"
Dopasowanie "abcabcabcdefabc" na pozycjach 0-14
Wyraenie regularne: "abc+"
Dopasowanie "abc" na pozycjach 0-2
Dopasowanie "abc" na pozycjach 3-5
Dopasowanie "abc" na pozycjach 6-8
Dopasowanie "abc" na pozycjach 12-14
Wyraenie regularne: "(abc)+"
Dopasowanie "abcabcabc" na pozycjach 0-8
Dopasowanie "abc" na pozycjach 12-14
Wyraenie regularne: "(abc){2,}"
Dopasowanie "abcabcabc" na pozycjach 0-8
*///:~
