//: strings/StartEnd.java
import java.util.regex.*;
import static net.mindview.util.Print.*;

public class StartEnd {
  public static String input =
    "Jak dugo bdzie istniaa niesprawiedliwo,\n" +
    "kiedykolwiek zapacze targathiaskie dziecko,\n" +
    "gdziekolwiek pord gwiazd\n zabrzmi wezwanie pomocy...\n" +
    "Bdziemy tam\n." +
    "Ten wspaniay statek i ta wspaniaa zaoga...\n" +
    "Nigdy zrezygnuje! Nigdy si nie podda!";
  private static class Display {
    private boolean regexPrinted = false;
    private String regex;
    Display(String regex) { this.regex = regex; }
    void display(String message) {
      if(!regexPrinted) {
        print(regex);
        regexPrinted = true;
      }
      print(message);
    }
  }
  static void examine(String s, String regex) {
    Display d = new Display(regex);
    Pattern p = Pattern.compile(regex);
    Matcher m = p.matcher(s);
    while(m.find())
      d.display("find() '" + m.group() +
        "' start = "+ m.start() + " end = " + m.end());
    if(m.lookingAt()) // Wywoanie reset() zbdne
      d.display("lookingAt() start = "
        + m.start() + " end = " + m.end());
    if(m.matches()) // Wywoanie reset() zbdne
      d.display("matches() start = "
        + m.start() + " end = " + m.end());
  }
  public static void main(String[] args) {
    for(String in : input.split("\n")) {
      print("Wejcie : " + in);
      for(String regex : new String[]{"\\w*zie\\w*",
        "\\w*kolwiek", "T\\w+", "Nigdy.*?!"})
        examine(in, regex);
    }
  }
} /* Output:
Wejcie : Jak dugo bdzie istniaa niesprawiedliwo,
\w*zie\w*
find() 'dzie' start = 12 end = 16
Wejcie : kiedykolwiek zapacze targathiaskie dziecko,
\w*zie\w*
find() 'dziecko' start = 37 end = 44
\w*kolwiek
find() 'kiedykolwiek' start = 0 end = 12
lookingAt() start = 0 end = 12
T\w+
find() 'targathia' start = 22 end = 31
Wejcie : gdziekolwiek pord gwiazd
\w*zie\w*
find() 'gdziekolwiek' start = 0 end = 12
lookingAt() start = 0 end = 12
\w*kolwiek
find() 'gdziekolwiek' start = 0 end = 12
lookingAt() start = 0 end = 12
Wejcie :  zabrzmi wezwanie pomocy...
Wejcie : Bdziemy tam
\w*zie\w*
find() 'dziemy' start = 2 end = 8
Wejcie : .Ten wspaniay statek i ta wspaniaa zaoga...
T\w+
find() 'Ten' start = 1 end = 4
Wejcie : Nigdy zrezygnuje! Nigdy si nie podda!
Nigdy.*?!
find() 'Nigdy zrezygnuje!' start = 0 end = 17
find() 'Nigdy si nie podda!' start = 18 end = 38
lookingAt() start = 0 end = 17
matches() start = 0 end = 38
*///:~
