//: reusing/FinalData.java
// Wpyw sowa "final" na skadowe danych.
import java.util.*;
import static net.mindview.util.Print.*;

class Value {
  int i; // DOstp pakietowy
  public Value(int i) { this.i = i; }
}

public class FinalData {
  private static Random rand = new Random(47);
  private String id;
  public FinalData(String id) { this.id = id; }
  // Mog by staymi czasu kompilacji:
  private final int valueOne = 9;
  private static final int VALUE_TWO = 99;
  // Typowa staa publiczna:
  public static final int VALUE_THREE = 39;
  // Nie mog by staymi czasu kompilacji:
  private final int i4 = rand.nextInt(20);
  static final int INT_5 = rand.nextInt(20);
  private Value v1 = new Value(11);
  private final Value v2 = new Value(22);
  private static final Value VAL_3 = new Value(33);
  // Tablice:
  private final int[] a = { 1, 2, 3, 4, 5, 6 };
  public String toString() {
    return id + ": " + "i4 = " + i4 + ", INT_5 = " + INT_5;
  }
  public static void main(String[] args) {
    FinalData fd1 = new FinalData("fd1");
    //! fd1.valueOne++; // Bd: nie mona zmienia wartoci
    fd1.v2.i++; // Obiekt nie jest sta!
    fd1.v1 = new Value(9); // W porzdku -- pole nie jest finalne
    for(int i = 0; i < fd1.a.length; i++)
      fd1.a[i]++; // Obiekt nie jest sta!
    //! fd1.v2 = new Value(0); // Bd: nie da si
    //! fd1.VAL_3 = new Value(1); // Zmiana referencji
    //! fd1.a = new int[3];
    print(fd1);
    print("Tworzenie nowego obiektu FinalData");
    FinalData fd2 = new FinalData("fd2");
    print(fd1);
    print(fd2);
  }
} /* Output:
fd1: i4 = 15, INT_5 = 18
Tworzenie nowego obiektu FinalData
fd1: i4 = 15, INT_5 = 18
fd2: i4 = 13, INT_5 = 18
*///:~
