//: polymorphism/PolyConstructors.java
// Konstruktory a polimorfizm
// - nieoczekiwane zachowanie.
import static net.mindview.util.Print.*;

class Glyph {
  void draw() { print("Glyph.draw()"); }
  Glyph() {
    print("Glyph() przed draw()");
    draw();
    print("Glyph() po draw()");
  }
}	

class RoundGlyph extends Glyph {
  private int radius = 1;
  RoundGlyph(int r) {
    radius = r;
    print("RoundGlyph.RoundGlyph(), radius = " + radius);
  }
  void draw() {
    print("RoundGlyph.draw(), radius = " + radius);
  }
}	

public class PolyConstructors {
  public static void main(String[] args) {
    new RoundGlyph(5);
  }
} /* Output:
Glyph() przed draw()
RoundGlyph.draw(), radius = 0
Glyph() po draw()
RoundGlyph.RoundGlyph(), radius = 5
*///:~
