//: io/ZipCompress.java
// Uycie algorytmu ZIP do kompresji dowolnej liczby
// plikw podanych w wierszu wywoania programu.
// {Args: ZipCompress.java}
import java.util.zip.*;
import java.io.*;
import java.util.*;
import static net.mindview.util.Print.*;

public class ZipCompress {
  public static void main(String[] args)
  throws IOException {
    FileOutputStream f = new FileOutputStream("test.zip");
    CheckedOutputStream csum =
      new CheckedOutputStream(f, new Adler32());
     ZipOutputStream zos = new ZipOutputStream(csum);
     BufferedOutputStream out =
      new BufferedOutputStream(zos);
    zos.setComment("Test kompresji w Javie");
    // Brak odpowiedniego wywoania getComment().
    for(String arg : args) {
      print("Zapis pliku " + arg);
      BufferedInputStream in =
        new BufferedInputStream(new FileInputStream(arg));
      zos.putNextEntry(new ZipEntry(arg));
      int c;
      while((c = in.read()) != -1)
        out.write(c);
      in.close();
      out.flush();
    }
    out.close();
    // Sumy kontrolne s wane dopiero po zamkniciu pliku!
    print("Suma kontrolna: " + csum.getChecksum().getValue());
    // A teraz wydobycie plikw:
    print("Odczyt pliku");
    FileInputStream fi = new FileInputStream("test.zip");
    CheckedInputStream csumi =
      new CheckedInputStream(fi, new Adler32());
    ZipInputStream in2 = new ZipInputStream(csumi);
    BufferedInputStream bis = new BufferedInputStream(in2);
    ZipEntry ze;
    while((ze = in2.getNextEntry()) != null) {
      print("Odczyt pliku " + ze);
      int x;
      while((x = bis.read()) != -1)
        System.out.write(x);
    }
    if(args.length == 1)
    print("Suma kontrolna: " + csumi.getChecksum().getValue());
    bis.close();
    // Alternatywny sposb otwierania i wczytywania archiww Zip:
    ZipFile zf = new ZipFile("test.zip");
    Enumeration e = zf.entries();
    while(e.hasMoreElements()) {
      ZipEntry ze2 = (ZipEntry)e.nextElement();
      print("Plik: " + ze2);
      // ... tu wydobywanie danych jak poprzednio
    }
    /* if(args.length == 1) */
  }
} /* (Execute to see output) *///:~
