//: io/MyWorld.java
import java.io.*;
import java.util.*;
import static net.mindview.util.Print.*;

class House implements Serializable {}

class Animal implements Serializable {
  private String name;
  private House preferredHouse;
  Animal(String nm, House h) {
    name = nm;
    preferredHouse = h;
  }
  public String toString() {
    return name + "[" + super.toString() +
      "], " + preferredHouse + "\n";
  }
}

public class MyWorld {
  public static void main(String[] args)
  throws IOException, ClassNotFoundException {
    House house = new House();
    List<Animal> animals = new ArrayList<Animal>();
    animals.add(new Animal("Kundel Bosco", house));
    animals.add(new Animal("Chomik Reks", house));
    animals.add(new Animal("Kotka Molly", house));
    print("animals: " + animals);
    ByteArrayOutputStream buf1 =
      new ByteArrayOutputStream();
    ObjectOutputStream o1 = new ObjectOutputStream(buf1);
    o1.writeObject(animals);
    o1.writeObject(animals); // Zapis drugiego zestawu
    // Zapis do innego strumienia:
    ByteArrayOutputStream buf2 =
      new ByteArrayOutputStream();
    ObjectOutputStream o2 = new ObjectOutputStream(buf2);
    o2.writeObject(animals);
    // A teraz odtwarzanie:
    ObjectInputStream in1 = new ObjectInputStream(
      new ByteArrayInputStream(buf1.toByteArray()));
    ObjectInputStream in2 = new ObjectInputStream(
      new ByteArrayInputStream(buf2.toByteArray()));
    List
      animals1 = (List)in1.readObject(),
      animals2 = (List)in1.readObject(),
      animals3 = (List)in2.readObject();
    print("animals1: " + animals1);
    print("animals2: " + animals2);
    print("animals3: " + animals3);
  }
} /* Output: (Sample)
animals: [Kundel Bosco[Animal@addbf1], House@42e816
, Chomik Reks[Animal@9304b1], House@42e816
, Kotka Molly[Animal@190d11], House@42e816
]
animals1: [Kundel Bosco[Animal@de6f34], House@156ee8e
, Chomik Reks[Animal@47b480], House@156ee8e
, Kotka Molly[Animal@19b49e6], House@156ee8e
]
animals2: [Kundel Bosco[Animal@de6f34], House@156ee8e
, Chomik Reks[Animal@47b480], House@156ee8e
, Kotka Molly[Animal@19b49e6], House@156ee8e
]
animals3: [Kundel Bosco[Animal@10d448], House@e0e1c6
, Chomik Reks[Animal@6ca1c], House@e0e1c6
, Kotka Molly[Animal@1bf216a], House@e0e1c6
]
*///:~
