//: io/MakeDirectories.java
// Demonstruje uycie klasy File do tworzenia
// katalogw i manipulowania plikami.
// {Args: MakeDirectoriesTest}
import java.io.*;

public class MakeDirectories {
  private static void usage() {
    System.err.println(
      "Stosowanie:MakeDirectories cieka1 ...\n" +
      "Tworzy wymienione cieki\n" +
      "Stosowanie:MakeDirectories -d cieka1 ...\n" +
      "Usuwa wymienione cieki\n" +
      "Stosowanie:MakeDirectories -r cieka1 cieka2\n" +
      "Zmiana nazwy ze cieka1 na cieka2");
    System.exit(1);
  }
  private static void fileData(File f) {
    System.out.println(
      "cieka bezwzgldna: " + f.getAbsolutePath() +
      "\n Do odczytu: " + f.canRead() +
      "\n Do zapisu: " + f.canWrite() +
      "\n Nazwa: " + f.getName() +
      "\n Nadrzdny: " + f.getParent() +
      "\n cieka: " + f.getPath() +
      "\n rozmiar: " + f.length() +
      "\n Ostatnia modyfikacja: " + f.lastModified());
    if(f.isFile())
      System.out.println("To plik");
    else if(f.isDirectory())
      System.out.println("To katalog");
  }
  public static void main(String[] args) {
    if(args.length < 1) usage();
    if(args[0].equals("-r")) {
      if(args.length != 3) usage();
      File
        old = new File(args[1]),
        rname = new File(args[2]);
      old.renameTo(rname);
      fileData(old);
      fileData(rname);
      return; // Wyjcie z metody main
    }
    int count = 0;
    boolean del = false;
    if(args[0].equals("-d")) {
      count++;
      del = true;
    }
    count--;
    while(++count < args.length) {
      File f = new File(args[count]);
      if(f.exists()) {
        System.out.println(f + " istnieje");
        if(del) {
          System.out.println("usuwanie..." + f);
          f.delete();
        }
      }
      else { // Nie istnieje
        if(!del) {
          f.mkdirs();
          System.out.println("utworzono " + f);
        }
      }
      fileData(f);
    }
  }
} /* Output: (80% match)
utworzono MakeDirectoriesTest
cieka bezwzgldna: E:\TIJ4\code\io\MakeDirectoriesTest
 Do odczytu: true
 Do zapisu: true
 Nazwa: MakeDirectoriesTest
 Nadrzdny: null
 cieka: MakeDirectoriesTest
 rozmiar: 0
 Ostatnia modyfikacja: 1142504694000
To katalog
*///:~
