//: io/Blip3.java
// Rekonstrukcja obiektw Externalizable.
import java.io.*;
import static net.mindview.util.Print.*;

public class Blip3 implements Externalizable {
  private int i;
  private String s; // Bez inicjalizacji
  public Blip3() {
    print("Konstruktor Blip3");
    // s oraz i niezainicjalizowane
  }
  public Blip3(String x, int a) {
    print("Blip3(String x, int a)");
    s = x;
    i = a;
    // s oraz i inicjalizowane jedynie w konstruktorze
    // innym ni domylny.
  }
  public String toString() { return s + i; }
  public void writeExternal(ObjectOutput out)
  throws IOException {
    print("Blip3.writeExternal");
    // Koniecznie:
    out.writeObject(s);
    out.writeInt(i);
  }
  public void readExternal(ObjectInput in)
  throws IOException, ClassNotFoundException {
    print("Blip3.readExternal");
    // Koniecznie:
    s = (String)in.readObject();
    i = in.readInt();
  }
  public static void main(String[] args)
  throws IOException, ClassNotFoundException {
    print("Konstrukcja obiektw:");
    Blip3 b3 = new Blip3("Cig znakw ", 47);
    print(b3);
    ObjectOutputStream o = new ObjectOutputStream(
      new FileOutputStream("Blip3.out"));
    print("Zapis obiektw:");
    o.writeObject(b3);
    o.close();
    // A teraz odtworzenie:
    ObjectInputStream in = new ObjectInputStream(
      new FileInputStream("Blip3.out"));
    print("Odtwarzanie b3:");
    b3 = (Blip3)in.readObject();
    print(b3);
  }
} /* Output:
Konstrukcja obiektw:
Blip3(String x, int a)
Cig znakw 47
Zapis obiektw:
Blip3.writeExternal
Odtwarzanie b3:
Konstruktor Blip3
Blip3.readExternal
Cig znakw 47
*///:~
