//: interfaces/interfaceprocessor/StringProcessor.java
package interfaces.interfaceprocessor;
import java.util.*;

public abstract class StringProcessor implements Processor{
  public String name() {
    return getClass().getSimpleName();
  }
  public abstract String process(Object input);
  public static String s =
    "Jeli ona way tyle, co kaczka, to znaczy e jest z drewna";
  public static void main(String[] args) {
    Apply.process(new Upcase(), s);
    Apply.process(new Downcase(), s);
    Apply.process(new Splitter(), s);
  }
}	

class Upcase extends StringProcessor {
  public String process(Object input) { // Kowariancja typu zwracanego
    return ((String)input).toUpperCase();
  }
}

class Downcase extends StringProcessor {
  public String process(Object input) {
    return ((String)input).toLowerCase();
  }
}

class Splitter extends StringProcessor {
  public String process(Object input) {
    return Arrays.toString(((String)input).split(" "));
  }	
} /* Output:
Uywam procesora Upcase
JELI ONA WAY TYLE, CO KACZKA, TO ZNACZY E JEST Z DREWNA
Uywam procesora Downcase
jeli ona way tyle, co kaczka, to znaczy e jest z drewna
Uywam procesora Splitter
[Jeli, ona, way, tyle,, co, kaczka,, to, znaczy, e, jest, z, drewna]
*///:~
