//: interfaces/classprocessor/Apply.java
package interfaces.classprocessor;
import java.util.*;
import static net.mindview.util.Print.*;

class Processor {
  public String name() {
    return getClass().getSimpleName();
  }
  Object process(Object input) { return input; }
}	

class Upcase extends Processor {
  String process(Object input) { // Kowariancja typu zwracanego
    return ((String)input).toUpperCase();
  }
}

class Downcase extends Processor {
  String process(Object input) {
    return ((String)input).toLowerCase();
  }
}

class Splitter extends Processor {
  String process(Object input) {
    // Metoda split() dzieli cig na podcigi:
    return Arrays.toString(((String)input).split(" "));
  }
}	

public class Apply {
  public static void process(Processor p, Object s) {
    print("Uywam procesora " + p.name());
    print(p.process(s));
  }
  public static String s =
    "Idzie Grze przez wie worek piasku niesie";
  public static void main(String[] args) {
    process(new Upcase(), s);
    process(new Downcase(), s);
    process(new Splitter(), s);
  }
} /* Output:
Uywam procesora Upcase
IDZIE GRZE PRZEZ WIE WOREK PIASKU NIESIE
Uywam procesora Downcase
idzie grze przez wie worek piasku niesie
Uywam procesora Splitter
[Idzie, Grze, przez, wie, worek, piasku, niesie]
*///:~
