//: initialization/TerminationCondition.java
// Wykorzystanie finalize() do wykrywania obiektu,
// ktry nie zosta odpowiednio "sprztnity".

class Book {
  boolean checkedOut = false;
  Book(boolean checkOut) {
    checkedOut = checkOut;
  }
  void checkIn() {
    checkedOut = false;
  }
  protected void finalize() {
    if(checkedOut)
      System.out.println("Bd:  w obiegu");
    // Normalnie uyby rwnie tego:
    // super.finalize(); // Wywoanie wersji z klasy bazowej
  }
}

public class TerminationCondition {
  public static void main(String[] args) {
    Book novel = new Book(true);
    // Waciwe "sprztanie":
    novel.checkIn();
    // Zarzucenie referencji, przeoczenie sprztania:
    new Book(true);
    // Wymuszenie odmiecania pamici i finalizacji:
    System.gc();
  }
} /* Output:
Bd: w obiegu
*///:~
