//: initialization/Overloading.java
// Demonstracja przeciania konstruktorw
// i zwykych metod klas.
import static net.mindview.util.Print.*;

class Tree {
  int height;
  Tree() {
    print("Sadzenie sadzonki");
    height = 0;
  }
  Tree(int initialHeight) {
    height = initialHeight;
    print("Tworzenie nowego drzewka, wysokiego na " +
      height + " metr(y)(w)");
  }	
  void info() {
    print("Drzewo ma " + height + " metr(y)(w) wysokoci");
  }
  void info(String s) {
    print(s + ": drzewo ma " + height + " metr(y)(w) wysokoci");
  }
}

public class Overloading {
  public static void main(String[] args) {
    for(int i = 0; i < 5; i++) {
      Tree t = new Tree(i);
      t.info();
      t.info("metoda przeciona");
    }
    // Przeciony konstruktor:
    new Tree();
  }	
} /* Output:
Tworzenie nowego drzewka, wysokiego na 0 metr(y)(w)
Drzewo ma 0 metr(y)(w) wysokoci
metoda przeciona: drzewo ma 0 metr(y)(w) wysokoci
Tworzenie nowego drzewka, wysokiego na 1 metr(y)(w)
Drzewo ma 1 metr(y)(w) wysokoci
metoda przeciona: drzewo ma 1 metr(y)(w) wysokoci
Tworzenie nowego drzewka, wysokiego na 2 metr(y)(w)
Drzewo ma 2 metr(y)(w) wysokoci
metoda przeciona: drzewo ma 2 metr(y)(w) wysokoci
Tworzenie nowego drzewka, wysokiego na 3 metr(y)(w)
Drzewo ma 3 metr(y)(w) wysokoci
metoda przeciona: drzewo ma 3 metr(y)(w) wysokoci
Tworzenie nowego drzewka, wysokiego na 4 metr(y)(w)
Drzewo ma 4 metr(y)(w) wysokoci
metoda przeciona: drzewo ma 4 metr(y)(w) wysokoci
Sadzenie sadzonki
*///:~
