//: holding/MapOfList.java
package holding;
import typeinfo.pets.*;
import java.util.*;
import static net.mindview.util.Print.*;

public class MapOfList {
  public static Map<Person, List<? extends Pet>>
    petPeople = new HashMap<Person, List<? extends Pet>>();
  static {
    petPeople.put(new Person("Tomasz"),
      Arrays.asList(new Cymric("Molly"),new Mutt("Spot")));
    petPeople.put(new Person("Kasia"),
      Arrays.asList(new Cat("Szoru"),
        new Cat("Maa Lu"), new Dog("Marten")));
    petPeople.put(new Person("Marysia"),
      Arrays.asList(
       new Pug("Lolo vel Leonard Moppsen"),
       new Cat("Stefan vel Czarny obuz"),
       new Cat("Pinkola")));	
    petPeople.put(new Person("Lucek"),
      Arrays.asList(new Rat("Gonek"), new Rat("Lelek")));
    petPeople.put(new Person("Jakub"),
      Arrays.asList(new Rat("Kolka")));
  }
  public static void main(String[] args) {
    print("Osoby: " + petPeople.keySet());
    print("Zwierzaki: " + petPeople.values());
    for(Person person : petPeople.keySet()) {
      print(person + " ma:");
      for(Pet pet : petPeople.get(person))
        print("    " + pet);
    }
  }
} /* Output:	
Osoby: [Person Lucek, Person Marysia, Person Jakub, Person Tomasz, Person Kasia]
Zwierzaki: [[Rat Gonek, Rat Lelek], [Pug Lolo vel Leonard Moppsen, Cat Stefan vel Czarny obuz, Cat Pinkola], [Rat Kolka], [Cymric Molly, Mutt Spot], [Cat Szoru, Cat Maa Lu, Dog Marten]]
Person Lucek ma:
    Rat Gonek
    Rat Lelek
Person Marysia ma:
    Pug Lolo vel Leonard Moppsen
    Cat Stefan vel Czarny obuz
    Cat Pinkola
Person Jakub has:
    Rat Kolka
Person Tomasz has:
    Cymric Molly
    Mutt Spot
Person Kasia has:
    Cat Szoru
    Cat Maa Lu
    Dog Marten
*///:~
