//: holding/IterableClass.java
// Z foreach dziaa wszystko, co implementuje interfejs Iterable.
import java.util.*;

public class IterableClass implements Iterable<String> {
  protected String[] words = ("i std wanie wiemy, e " +
    "Ziemia ma ksztat banana.").split(" ");
  public Iterator<String> iterator() {
    return new Iterator<String>() {
      private int index = 0;
      public boolean hasNext() {
        return index < words.length;
      }
      public String next() { return words[index++]; }
      public void remove() { // Niezaimplementowana
        throw new UnsupportedOperationException();
      }
    };
  }	
  public static void main(String[] args) {
    for(String s : new IterableClass())
      System.out.print(s + " ");
  }
} /* Output:
I std wanie wiemy, e Ziemia ma ksztat banana.
*///:~
