//: holding/AsListInference.java
// Arrays.asList() zgaduje typ.
import java.util.*;

class Snow {}
class Powder extends Snow {}
class Light extends Powder {}
class Heavy extends Powder {}
class Crusty extends Snow {}
class Slush extends Snow {}

public class AsListInference {
  public static void main(String[] args) {
    List<Snow> snow1 = Arrays.asList(
      new Crusty(), new Slush(), new Powder());

    // Nie da si skompilowa:
    // List<Snow> snow2 = Arrays.asList(
    //   new Light(), new Heavy());
    // Kompilator stwierdzi:
    // found   : java.util.List<Powder>
    // required: java.util.List<Snow>

    // Collections.addAll() nie ma z tym problemu:
    List<Snow> snow3 = new ArrayList<Snow>();
    Collections.addAll(snow3, new Light(), new Heavy());

    // Pomoemy, jawnie podpowiadajc typ argumentu
    // explicit type argument specification:
    List<Snow> snow4 = Arrays.<Snow>asList(
       new Light(), new Heavy());
  }
} ///:~
