//: generics/Fill.java
// Uoglnianie pomysu na klas FilledList
// {main: FillTest}
import java.util.*;

// Nie dziaa z "czymkolwiek, co posiada metod add()." Nie mamy
// do dyspozycji innterfejsu "Addable"  wic ograniczamy oglno
// kodu do typw Collection. W tym przyupadku uoglnienia nie
// oznaczaj oglnoci.
public class Fill {
  public static <T> void fill(Collection<T> collection,
  Class<? extends T> classToken, int size) {
    for(int i = 0; i < size; i++)
      // Zakada dostpno konstruktora domylnego:
      try {
        collection.add(classToken.newInstance());
      } catch(Exception e) {
        throw new RuntimeException(e);
      }
  }
}

class Contract {
  private static long counter = 0;
  private final long id = counter++;
  public String toString() {
    return getClass().getName() + " " + id;
  }
}

class TitleTransfer extends Contract {}
	
class FillTest {
  public static void main(String[] args) {
    List<Contract> contracts = new ArrayList<Contract>();
    Fill.fill(contracts, Contract.class, 3);
    Fill.fill(contracts, TitleTransfer.class, 2);
    for(Contract c: contracts)
      System.out.println(c);
    SimpleQueue<Contract> contractQueue =
      new SimpleQueue<Contract>();
    // Nie zadziaa. Metoda fill() nie jest do oglna:
    // Fill.fill(contractQueue, Contract.class, 3);
  }
} /* Output:
Contract 0
Contract 1
Contract 2
TitleTransfer 3
TitleTransfer 4
*///:~
