//: generics/DogsAndRobots.java
// Brak typowania utajonego w Javie
import typeinfo.pets.*;
import static net.mindview.util.Print.*;

class PerformingDog extends Dog implements Performs {
  public void speak() { print("Hau!"); }
  public void sit() { print("Siada"); }
  public void reproduce() {}
}

class Robot implements Performs {
  public void speak() { print("Klik!"); }
  public void sit() { print("Zgrrt!"); }
  public void oilChange() {}
}	

class Communicate {
  public static <T extends Performs>
  void perform(T performer) {
    performer.speak();
    performer.sit();
  }
}

public class DogsAndRobots {
  public static void main(String[] args) {
    PerformingDog d = new PerformingDog();
    Robot r = new Robot();
    Communicate.perform(d);
    Communicate.perform(r);
  }
} /* Output:
Hau!
Siada
Klik!
Zgrrt!
*///:~
