//: generics/CaptureConversion.java

public class CaptureConversion {
  static <T> void f1(Holder<T> holder) {
    T t = holder.get();
    System.out.println(t.getClass().getSimpleName());
  }
  static void f2(Holder<?> holder) {
    f1(holder); // Wywoanie z przechwyconym typem
  }	
  @SuppressWarnings("unchecked")
  public static void main(String[] args) {
    Holder raw = new Holder<Integer>(1);
    // f1(raw); // Prowokuje ostrzeenia
    f2(raw); // Bez ostrzee
    Holder rawBasic = new Holder();
    rawBasic.set(new Object()); // Ostrzeenie
    f2(rawBasic); // Bez ostrzee
    // Rzutowanie w gr na Holder<?>, wci do wykrycia:
    Holder<?> wildcarded = new Holder<Double>(1.0);
    f2(wildcarded);
  }
} /* Output:
Integer
Object
Double
*///:~
