//: exceptions/RethrowNew.java
// Wyrzucenie wyjtku innego ni przechwycony.

class OneException extends Exception {
  public OneException(String s) { super(s); }
}

class TwoException extends Exception {
  public TwoException(String s) { super(s); }
}

public class RethrowNew {
  public static void f() throws OneException {
    System.out.println("wyjtek poczty w f()");
    throw new OneException("wyrucony z f()");
  }
  public static void main(String[] args) {
    try {
      try {
        f();
      } catch(OneException e) {
        System.out.println(
          "Przechwycony w wewntrznym bloku try, e.printStackTrace()");
        e.printStackTrace(System.out);
        throw new TwoException("wyrzucony z wewntrznego bloku try");
      }
    } catch(TwoException e) {
      System.out.println(
        "Przechwycony w zewntrznym bloku try, e.printStackTrace()");
      e.printStackTrace(System.out);
    }
  }
} /* Output:
wyjtek poczty w f()
Przechwycony w wewntrznym bloku try, e.printStackTrace()
OneException: wyrzucony z f()
        at RethrowNew.f(RethrowNew.java:15)
        at RethrowNew.main(RethrowNew.java:20)
Przechwycony w zewntrznym bloku try, e.printStackTrace()
TwoException: wyrzucony z wewntrznego bloku try
        at RethrowNew.main(RethrowNew.java:25)
*///:~
