//: exceptions/InputFile.java
// Uwaga na wyjtki w konstruktorach.
import java.io.*;

public class InputFile {
  private BufferedReader in;
  public InputFile(String fname) throws Exception {
    try {
      in = new BufferedReader(new FileReader(fname));
      // Reszta kodu, ktry mgby sprowokowa wyjtki
    } catch(FileNotFoundException e) {
      System.out.println("Nie mona otworzy pliku " + fname);
      // Plik nie by otwarty, wic go nie zamykamy
      throw e;
    } catch(Exception e) {
      // Wszystkie pozostae wyjtki musz zadba o zamknicie pliku
      try {
        in.close();
      } catch(IOException e2) {
        System.out.println("wywoanie in.close() nieskuteczne");
      }
      throw e; // Ponowne wyrzucenie wyjtku
    } finally {
      // Nie zamyka pliku tutaj!!!
    }
  }
  public String getLine() {
    String s;
    try {
      s = in.readLine();
    } catch(IOException e) {
      throw new RuntimeException("wywoanie readLine() nieskuteczne");
    }
    return s;
  }
  public void dispose() {
    try {
      in.close();
      System.out.println("wywoanie dispose() skuteczne");
    } catch(IOException e2) {
      throw new RuntimeException("wywoanie in.close() nieskuteczne");
    }
  }
} ///:~
