//: exceptions/FinallyWorks.java
// Blok finally jest wykonywany _zawsze_.

class ThreeException extends Exception {}

public class FinallyWorks {
  static int count = 0;
  public static void main(String[] args) {
    while(true) {
      try {
        // Post-inkrementacja za pierwszym razem zwraca zero
        if(count++ == 0)
          throw new ThreeException();
        System.out.println("Brak wyjtku");
      } catch(ThreeException e) {
        System.out.println("Wyjtek ThreeException");
      } finally {
        System.out.println("W bloku finally");
        if(count == 2) break; // wyjcie z ptli while
      }
    }
  }
} /* Output:
Wyjtek ThreeException
W bloku finally
Brak wyjtku
W bloku finally
*///:~
