//: exceptions/CleanupIdiom.java
// Kady obiekt musi mie wasny blok try-finally

class NeedsCleanup { // Konstrukcja zawsze udana
  private static long counter = 1;
  private final long id = counter++;
  public void dispose() {
    System.out.println("NeedsCleanup " + id + " uporzdkowany");
  }
}

class ConstructionException extends Exception {}

class NeedsCleanup2 extends NeedsCleanup {
  // Konstrukcja moe zawodzi:
  public NeedsCleanup2() throws ConstructionException {}
}

public class CleanupIdiom {
  public static void main(String[] args) {
    // Sekcja 1:
    NeedsCleanup nc1 = new NeedsCleanup();
    try {
      // ...
    } finally {
      nc1.dispose();
    }

    // Sekcja 2:
    // Jeli konstrukcja jet zawsze udana, mona zgrupowa oiekty:
    NeedsCleanup nc2 = new NeedsCleanup();
    NeedsCleanup nc3 = new NeedsCleanup();
    try {
      // ...
    } finally {
      nc3.dispose(); // Kolejno odwrotna do kolejnoci konstrukcji
      nc2.dispose();
    }

    // Sekcja 3:
    // Jeli konstrukcja moe zawie,
    // trzeba chroni kady obiekt z osobna
    try {
      NeedsCleanup2 nc4 = new NeedsCleanup2();
      try {
        NeedsCleanup2 nc5 = new NeedsCleanup2();
        try {
          // ...
        } finally {
          nc5.dispose();
        }
      } catch(ConstructionException e) { // Konstruktor nc5
        System.out.println(e);
      } finally {
        nc4.dispose();
      }
    } catch(ConstructionException e) { // Konstruktor nc4
      System.out.println(e);
    }
  }
} /* Output:
NeedsCleanup 1 uporzdkowany
NeedsCleanup 3 uporzdkowany
NeedsCleanup 2 uporzdkowany
NeedsCleanup 5 uporzdkowany
NeedsCleanup 4 uporzdkowany
*///:~
