//: exceptions/AlwaysFinally.java
// Blok finally jest wykonywany _zawszze_.
import static net.mindview.util.Print.*;

class FourException extends Exception {}

public class AlwaysFinally {
  public static void main(String[] args) {
    print("Wejcie do pierwszego bloku try");
    try {
      print("Wejcie do drugiego bloku try");
      try {
        throw new FourException();
      } finally {
        print("Blok finally w drugim bloku try");
      }
    } catch(FourException e) {
      System.out.println(
        "Przechwycono FourException w pierwszym bloku try");
    } finally {
      System.out.println("Blok finally w pierwszym bloku try");
    }
  }
} /* Output:
Wejcie do pierwszego bloku try
Wejcie do drugiego bloku try
Blok finally w drugim bloku try
Przechwycono FourException w pierwszym bloku try
Blok finally w pierwszym bloku try
*///:~
