//: enumerated/Reflection.java
// Analiza typw wyliczeniowych.
import java.lang.reflect.*;
import java.util.*;
import net.mindview.util.*;
import static net.mindview.util.Print.*;

enum Explore { HERE, THERE }

public class Reflection {
  public static Set<String> analyze(Class<?> enumClass) {
    print("----- Analiza: " + enumClass + " -----");
    print("Interfejsy:");
    for(Type t : enumClass.getGenericInterfaces())
      print(t);
    print("Klasa bazowa: " + enumClass.getSuperclass());
    print("Metody: ");
    Set<String> methods = new TreeSet<String>();
    for(Method m : enumClass.getMethods())
      methods.add(m.getName());
    print(methods);
    return methods;
  }
  public static void main(String[] args) {
    Set<String> exploreMethods = analyze(Explore.class);
    Set<String> enumMethods = analyze(Enum.class);
    print("Explore.containsAll(Enum)? " +
      exploreMethods.containsAll(enumMethods));
    printnb("Explore.removeAll(Enum): ");
    exploreMethods.removeAll(enumMethods);
    print(exploreMethods);
    // Dekompilacja kodu typu wyliczeniowego:
    OSExecute.command("javap Explore");
  }
} /* Output:
----- Analiza: class Explore -----
Interfejsy:
Klasa bazowa: class java.lang.Enum
Metody: 
[compareTo, equals, getClass, getDeclaringClass, hashCode, name, notify, notifyAll, ordinal, toString, valueOf, values, wait]
----- Analiza class java.lang.Enum -----
Interfejsy:
java.lang.Comparable<E>
interface java.io.Serializable
Klasa bazowa: class java.lang.Object
Metody: 
[compareTo, equals, getClass, getDeclaringClass, hashCode, name, notify, notifyAll, ordinal, toString, valueOf, wait]
Explore.containsAll(Enum)? true
Explore.removeAll(Enum): [values]
Compiled from "Reflection.java"
final class Explore extends java.lang.Enum{
    public static final Explore HERE;
    public static final Explore THERE;
    public static final Explore[] values();
    public static Explore valueOf(java.lang.String);
    static {};
}
*///:~
