//: enumerated/Input.java
package enumerated;
import java.util.*;

public enum Input {
  PITAK(5), DYCHA(10), DWUDZIESTKA(20), POWKA(50), ZOTY(100),
  PASTA(200), CHIPSY(75), COLA(100), MYDO(50),
  ABORT_TRANSACTION {
    public int amount() { // Niedozwolone
      throw new RuntimeException("ABORT.amount()");
    }
  },
  STOP { // To musi by ostatnia warto.
    public int amount() { // Niedozwolone
      throw new RuntimeException("STOP.amount()");
    }
  };	
  int value; // W groszach
  Input(int value) { this.value = value; }
  Input() {}
  int amount() { return value; }; // W groszach
  static Random rand = new Random(47);
  public static Input randomSelection() {
    // Bez STOP:
    return values()[rand.nextInt(values().length - 1)];
  }
} ///:~
