//: enumerated/EnumClass.java
// Cechy klasy Enum
import static net.mindview.util.Print.*;

enum Shrubbery { GROUND, CRAWLING, HANGING }

public class EnumClass {
  public static void main(String[] args) {
    for(Shrubbery s : Shrubbery.values()) {
      print(s + " liczba porzdkowa: " + s.ordinal());
      printnb(s.compareTo(Shrubbery.CRAWLING) + " ");
      printnb(s.equals(Shrubbery.CRAWLING) + " ");
      print(s == Shrubbery.CRAWLING);
      print(s.getDeclaringClass());
      print(s.name());
      print("----------------------");
    }
    // Wygenerowanie wartoci wyliczenia na podstawie cigu z nazw:
    for(String s : "HANGING CRAWLING GROUND".split(" ")) {
      Shrubbery shrub = Enum.valueOf(Shrubbery.class, s);
      print(shrub);
    }
  }
} /* Output:
GROUND liczba porzdkowa: 0
-1 false false
class Shrubbery
GROUND
----------------------
CRAWLING liczba porzdkowa: 1
0 true true
class Shrubbery
CRAWLING
----------------------
HANGING liczba porzdkowa: 2
1 false false
class Shrubbery
HANGING
----------------------
HANGING
CRAWLING
GROUND
*///:~
