//: enumerated/CarWash.java
import java.util.*;
import static net.mindview.util.Print.*;

public class CarWash {
  public enum Cycle {
    UNDERBODY {
      void action() { print("Cinieniowe pukanie podwozia"); }
    },
    WHEELWASH {
      void action() { print("Mycie k"); }
    },
    PREWASH {
      void action() { print("Pukanie wstpne"); }
    },
    BASIC {
      void action() { print("Mycie zasadnicze"); }
    },
    HOTWAX {
      void action() { print("Woskowanie na gorco"); }
    },
    RINSE {
      void action() { print("Pukanie"); }
    },
    BLOWDRY {
      void action() { print("Suszenie"); }
    };
    abstract void action();
  }
  EnumSet<Cycle> cycles =
    EnumSet.of(Cycle.BASIC, Cycle.RINSE);
  public void add(Cycle cycle) { cycles.add(cycle); }
  public void washCar() {
    for(Cycle c : cycles)
      c.action();
  }
  public String toString() { return cycles.toString(); }
  public static void main(String[] args) {
    CarWash wash = new CarWash();
    print(wash);
    wash.washCar();
    // Kolejno dodawania do kontenera jest nieistotna:
    wash.add(Cycle.BLOWDRY);
    wash.add(Cycle.BLOWDRY); // Duplikaty s ignorowane
    wash.add(Cycle.RINSE);
    wash.add(Cycle.HOTWAX);
    print(wash);
    wash.washCar();
  }
} /* Output:
[BASIC, RINSE]
Mycie zasadnicze
Pukanie
[BASIC, HOTWAX, RINSE, BLOWDRY]
Mycie zasadnicze
Woskowanie na gorco
Pukanie
Suszenie
*///:~
