//: control/BreakAndContinue.java
// Demonstracja dziaania sw kluczowych break i continue.
import static net.mindview.util.Range.*;

public class BreakAndContinue {
  public static void main(String[] args) {
    for(int i = 0; i < 100; i++) {
      if(i == 74) break; // Przerwanie ptli for
      if(i % 9 != 0) continue; // Nastpna iteracja
      System.out.print(i + " ");
    }
    System.out.println();
    // Z uyciem foreach:
    for(int i : range(100)) {
      if(i == 74) break; // Przerwanie ptli for
      if(i % 9 != 0) continue; // Nastpna iteracja
      System.out.print(i + " ");
    }
    System.out.println();
    int i = 0;
    // Ptla "nieskoczona":
    while(true) {
      i++;
      int j = i * 27;
      if(j == 1269) break; // Przerwanie ptli
      if(i % 10 != 0) continue; // Na pocztek ptli
      System.out.print(i + " ");
    }
  }
} /* Output:
0 9 18 27 36 45 54 63 72
0 9 18 27 36 45 54 63 72
10 20 30 40
*///:~
