//: containers/ReadOnly.java
// Zastosowanie metod Collections.unmodifiable...
import java.util.*;
import net.mindview.util.*;
import static net.mindview.util.Print.*;

public class ReadOnly {
  static Collection<String> data =
    new ArrayList<String>(Countries.names(6));
  public static void main(String[] args) {
    Collection<String> c =
      Collections.unmodifiableCollection(
        new ArrayList<String>(data));
    print(c); // Odczyt jest dozwolony
    //! c.add("jeden"); // Ale modyfikacje ju nie

    List<String> a = Collections.unmodifiableList(
        new ArrayList<String>(data));
    ListIterator<String> lit = a.listIterator();
    print(lit.next()); // Odczyt jest dozwolony
    //! lit.add("jeden"); // Ale modyfikacje ju nie

    Set<String> s = Collections.unmodifiableSet(
      new HashSet<String>(data));
    print(s); // Odczyt jest dozwolony
    //! s.add("jeden"); // Ale modyfikacje ju nie

    // Dla kontenera SortedSet:
    Set<String> ss = Collections.unmodifiableSortedSet(
      new TreeSet<String>(data));

    Map<String,String> m = Collections.unmodifiableMap(
      new HashMap<String,String>(Countries.capitals(6)));
    print(m); // Odczyt jest dozwolony
    //! m.put("Romek", "Hejka!");

    // Dla kontenera SortedMap:
    Map<String,String> sm =
      Collections.unmodifiableSortedMap(
        new TreeMap<String,String>(Countries.capitals(6)));
  }
} /* Output:
[ALGERIA, ANGOLA, BENIN, BOTSWANA, BULGARIA, BURKINA FASO]
ALGERIA
[BULGARIA, BURKINA FASO, BOTSWANA, BENIN, ANGOLA, ALGERIA]
{BULGARIA=Sofia, BURKINA FASO=Ouagadougou, BOTSWANA=Gaberone, BENIN=Porto-Novo, ANGOLA=Luanda, ALGERIA=Algiers}
*///:~
