//: containers/MapPerformance.java
// Ilustracja wydajnoci rnych implementacji Map.
// {Args: 100 5000} Maa liczba skraca czas dla systemu kompilacji
import java.util.*;

public class MapPerformance {
  static List<Test<Map<Integer,Integer>>> tests =
    new ArrayList<Test<Map<Integer,Integer>>>();
  static {
    tests.add(new Test<Map<Integer,Integer>>("put") {
      int test(Map<Integer,Integer> map, TestParam tp) {
        int loops = tp.loops;
        int size = tp.size;
        for(int i = 0; i < loops; i++) {
          map.clear();
          for(int j = 0; j < size; j++)
            map.put(j, j);
        }
        return loops * size;
      }
    });
    tests.add(new Test<Map<Integer,Integer>>("get") {
      int test(Map<Integer,Integer> map, TestParam tp) {
        int loops = tp.loops;
        int span = tp.size * 2;
        for(int i = 0; i < loops; i++)
          for(int j = 0; j < span; j++)
            map.get(j);
        return loops * span;
      }
    });
    tests.add(new Test<Map<Integer,Integer>>("iterate") {
      int test(Map<Integer,Integer> map, TestParam tp) {
        int loops = tp.loops * 10;
        for(int i = 0; i < loops; i ++) {
          Iterator it = map.entrySet().iterator();
          while(it.hasNext())
            it.next();
        }
        return loops * map.size();
      }
    });
  }
  public static void main(String[] args) {
    if(args.length > 0)
      Tester.defaultParams = TestParam.array(args);
    Tester.run(new TreeMap<Integer,Integer>(), tests);
    Tester.run(new HashMap<Integer,Integer>(), tests);
    Tester.run(new LinkedHashMap<Integer,Integer>(),tests);
    Tester.run(
      new IdentityHashMap<Integer,Integer>(), tests);
    Tester.run(new WeakHashMap<Integer,Integer>(), tests);
    Tester.run(new Hashtable<Integer,Integer>(), tests);
  }
} /* Output: (Sample)
------------ TreeMap ------------
 rozmiar     put     get iterate
      10     748     168     100
     100     506     264      76
    1000     771     450      78
   10000    2962     561      83
------------ HashMap ------------
 rozmiar     put     get iterate
      10     281      76      93
     100     179      70      73
    1000     267     102      72
   10000    1305     265      97
--------- LinkedHashMap ---------
 rozmiar     put     get iterate
      10     354     100      72
     100     273      89      50
    1000     385     222      56
   10000    2787     341      56
-------- IdentityHashMap --------
 rozmiar     put     get iterate
      10     290     144     101
     100     204     287     132
    1000     508     336      77
   10000     767     266      56
---------- WeakHashMap ----------
 rozmiar     put     get iterate
      10     484     146     151
     100     292     126     117
    1000     411     136     152
   10000    2165     138     555
----------- Hashtable -----------
 rozmiar     put     get iterate
      10     264     113     113
     100     181     105      76
    1000     260     201      80
   10000    1245     134      77
*///:~
