//: containers/CollectionMethods.java
// Co mona zrobi z kadym podtypem Collections.
import java.util.*;
import net.mindview.util.*;
import static net.mindview.util.Print.*;

public class CollectionMethods {
  public static void main(String[] args) {
    Collection<String> c = new ArrayList<String>();
    c.addAll(Countries.names(6));
    c.add("dziesi");
    c.add("jedenacie");
    print(c);
    // Utworzenie tablicy z kopi elementw listy:
    Object[] array = c.toArray();
    // Utworzenie tablicy cigw znakw na podstawie listy:
    String[] str = c.toArray(new String[0]);
    // Wyszukanie elementu najwikszego i najmniejszego;
    // znaczenie tych operacji bywa rne, zalenie od sposobu
    // implementowania interfejsu Comparable dla elementw:
    print("Collections.max(c) = " + Collections.max(c));
    print("Collections.min(c) = " + Collections.min(c));
    // Dodawanie kolekcji do innych kolekcji
    Collection<String> c2 = new ArrayList<String>();
    c2.addAll(Countries.names(6));
    c.addAll(c2);
    print(c);
    c.remove(Countries.DATA[0][0]);
    print(c);
    c.remove(Countries.DATA[1][0]);
    print(c);
    // Usunicie wszyskich elementw wymienionych
    // w kolekcji przekazanej argumentem wywoania:
    c.removeAll(c2);
    print(c);
    c.addAll(c2);
    print(c);
    // Czy w tej kolekcji znajduje si dany element?
    String val = Countries.DATA[3][0];
    print("c.contains(" + val  + ") = " + c.contains(val));
    // Czy w tej kolekcji znajduje si komplet elementw danej kolekcji?
    print("c.containsAll(c2) = " + c.containsAll(c2));
    Collection<String> c3 =
      ((List<String>)c).subList(3, 5);
    // Zachowanie wszystkich elementw znajdujcych si w
    // kolekcjach c2 i c3 (cz wsplna kolekcji):
    c2.retainAll(c3);
    print(c2);
    // Pozbycie si elementw z c2, ktre znajduj si
    // rwnie w kolekcji c3:
    c2.removeAll(c3);
    print("c2.isEmpty() = " +  c2.isEmpty());
    c = new ArrayList<String>();
    c.addAll(Countries.names(6));
    print(c);
    c.clear(); // Usunicie wszystkich elementw kolekcji
    print("po c.clear():" + c);
  }
} /* Output:
[ALGERIA, ANGOLA, BENIN, BOTSWANA, BULGARIA, BURKINA FASO, dziesi, jedenacie]
Collections.max(c) = dziesi
Collections.min(c) = ALGERIA
[ALGERIA, ANGOLA, BENIN, BOTSWANA, BULGARIA, BURKINA FASO, dziesi, jedenacie, ALGERIA, ANGOLA, BENIN, BOTSWANA, BULGARIA, BURKINA FASO]
[ANGOLA, BENIN, BOTSWANA, BULGARIA, BURKINA FASO, dziesi, jedenacie, ALGERIA, ANGOLA, BENIN, BOTSWANA, BULGARIA, BURKINA FASO]
[BENIN, BOTSWANA, BULGARIA, BURKINA FASO, dziesi, jedenacie, ALGERIA, ANGOLA, BENIN, BOTSWANA, BULGARIA, BURKINA FASO]
[dziesi, jedenacie]
[dziesi, jedenacie, ALGERIA, ANGOLA, BENIN, BOTSWANA, BULGARIA, BURKINA FASO]
c.contains(BOTSWANA) = true
c.containsAll(c2) = true
[ANGOLA, BENIN]
c2.isEmpty() = true
[ALGERIA, ANGOLA, BENIN, BOTSWANA, BULGARIA, BURKINA FASO]
po c.clear():[]
*///:~
