//: containers/AssociativeArray.java
// Kojarzenie kluczy z wartociami.
import static net.mindview.util.Print.*;

public class AssociativeArray<K,V> {
  private Object[][] pairs;
  private int index;
  public AssociativeArray(int length) {
    pairs = new Object[length][2];
  }
  public void put(K key, V value) {
    if(index >= pairs.length)
      throw new ArrayIndexOutOfBoundsException();
    pairs[index++] = new Object[]{ key, value };
  }
  @SuppressWarnings("unchecked")
  public V get(K key) {
    for(int i = 0; i < index; i++)
      if(key.equals(pairs[i][0]))
        return (V)pairs[i][1];
    return null; // Brak szukanego klucza
  }
  public String toString() {
    StringBuilder result = new StringBuilder();
    for(int i = 0; i < index; i++) {
      result.append(pairs[i][0].toString());
      result.append(" : ");
      result.append(pairs[i][1].toString());
      if(i < index - 1)
        result.append("\n");
    }
    return result.toString();
  }
  public static void main(String[] args) {
    AssociativeArray<String,String> map =
      new AssociativeArray<String,String>(6);
    map.put("niebo", "niebieskie");
    map.put("trawa", "zielona");
    map.put("ocean", "falujcy");
    map.put("drzewo", "wysokie");
    map.put("ziemia", "brzowa");
    map.put("soce", "gorce");
    try {
      map.put("ekstra", "obiekt"); // Za kocem
    } catch(ArrayIndexOutOfBoundsException e) {
      print("Za duo obiektw!");
    }
    print(map);
    print(map.get("ocean"));
  }
} /* Output:
Za duo obiektw!
niebo : niebieskie
trawa : zielona
ocean : falujcy
drzewo : wysokie
ziemia : brzowa
soce : gorce
falujcy
*///:~
