//: concurrency/waxomatic2/WaxOMatic2.java
// Zastosowanie obiektw Lock i Condition.
package concurrency.waxomatic2;
import java.util.concurrent.*;
import java.util.concurrent.locks.*;
import static net.mindview.util.Print.*;

class Car {
  private Lock lock = new ReentrantLock();
  private Condition condition = lock.newCondition();
  private boolean waxOn = false;
  public void waxed() {
    lock.lock();
    try {
      waxOn = true; // Gotowy do polerowania
      condition.signalAll();
    } finally {
      lock.unlock();
    }
  }
  public void buffed() {
    lock.lock();
    try {
      waxOn = false; // Gotowy do naoenia nastpnej warstwy wosku
      condition.signalAll();
    } finally {
      lock.unlock();
    }
  }
  public void waitForWaxing() throws InterruptedException {
    lock.lock();
    try {
      while(waxOn == false)
        condition.await();
    } finally {
      lock.unlock();
    }
  }
  public void waitForBuffing() throws InterruptedException{
    lock.lock();
    try {
      while(waxOn == true)
        condition.await();
    } finally {
      lock.unlock();
    }
  }
}

class WaxOn implements Runnable {
  private Car car;
  public WaxOn(Car c) { car = c; }
  public void run() {
    try {
      while(!Thread.interrupted()) {
        printnb("Woskowanie! ");
        TimeUnit.MILLISECONDS.sleep(200);
        car.waxed();
        car.waitForBuffing();
      }
    } catch(InterruptedException e) {
      print("Wyjcie wymuszone przerwaniem");
    }
    print("Koniec zadania woskowania");
  }
}

class WaxOff implements Runnable {
  private Car car;
  public WaxOff(Car c) { car = c; }
  public void run() {
    try {
      while(!Thread.interrupted()) {
        car.waitForWaxing();
        printnb("Polerowanie! ");
        TimeUnit.MILLISECONDS.sleep(200);
        car.buffed();
      }
    } catch(InterruptedException e) {
      print("Wyjcie wymuszone przerwaniem");
    }
    print("Koniec zadania polerowania");
  }
}

public class WaxOMatic2 {
  public static void main(String[] args) throws Exception {
    Car car = new Car();
    ExecutorService exec = Executors.newCachedThreadPool();
    exec.execute(new WaxOff(car));
    exec.execute(new WaxOn(car));
    TimeUnit.SECONDS.sleep(5);
    exec.shutdownNow();
  }
} /* Output: (90% match)
Woskowanie! Polerowanie! Woskowanie! Polerowanie! Woskowanie! Polerowanie! Woskowanie! Polerowanie! Woskowanie! Polerowanie! Woskowanie! Polerowanie! Woskowanie! Polerowanie! Woskowanie! Polerowanie! Woskowanie! Polerowanie! Woskowanie! Polerowanie! Woskowanie! Polerowanie! Woskowanie! Polerowanie! Woskowanie! Wyjcie wymuszone przerwaniem
Koniec zadania polerowania
Wyjcie wymuszone przerwaniem
Koniec zadania woskowania
*///:~
