//: concurrency/SerialNumberChecker.java
// Operacje pozornie bezpieczne nie s takimi,
// kiedy mamy do czynienia z wtkami.
// {Args: 4}
import java.util.concurrent.*;

// Klasa cyklicznie wykorzystujca przydzielon pami:
class CircularSet {
  private int[] array;
  private int len;
  private int index = 0;
  public CircularSet(int size) {
    array = new int[size];
    len = size;
    // Inicjalizacja wartoci nie generowan
    // przez generator SerialNumberGenerator:
    for(int i = 0; i < size; i++)
      array[i] = -1;
  }
  public synchronized void add(int i) {
    array[index] = i;
    // "Zawinicie" indeksu i zamazywanie "starych" elementw:
    index = ++index % len;
  }
  public synchronized boolean contains(int val) {
    for(int i = 0; i < len; i++)
      if(array[i] == val) return true;
    return false;
  }
}

public class SerialNumberChecker {
  private static final int SIZE = 10;
  private static CircularSet serials =
    new CircularSet(1000);
  private static ExecutorService exec =
    Executors.newCachedThreadPool();
  static class SerialChecker implements Runnable {
    public void run() {
      while(true) {
        int serial =
          SerialNumberGenerator.nextSerialNumber();
        if(serials.contains(serial)) {
          System.out.println("Duplikat: " + serial);
          System.exit(0);
        }
        serials.add(serial);
      }
    }
  }
  public static void main(String[] args) throws Exception {
    for(int i = 0; i < SIZE; i++)
      exec.execute(new SerialChecker());
    // Ewentualny argument wstrzymuje wykonanie wtku main():
    if(args.length > 0) {
      TimeUnit.SECONDS.sleep(new Integer(args[0]));
      System.out.println("Nie wykryto duplikatw");
      System.exit(0);
    }
  }
} /* Output: (Sample)
Duplikat: 8468656
*///:~
