//: concurrency/OrnamentalGarden.java
import java.util.concurrent.*;
import java.util.*;
import static net.mindview.util.Print.*;

class Count {
  private int count = 0;
  private Random rand = new Random(47);
  // Usunicie sowa synchronized sprowokuje bd:
  public synchronized int increment() {
    int temp = count;
    if(rand.nextBoolean()) // Oddanie (mniej wicej) poowy czasu zadania
      Thread.yield();
    return (count = ++temp);
  }
  public synchronized int value() { return count; }
}

class Entrance implements Runnable {
  private static Count count = new Count();
  private static List<Entrance> entrances =
    new ArrayList<Entrance>();
  private int number = 0;
  // Odczyt nie wymaga synchronizacji:
  private final int id;
  private static volatile boolean canceled = false;
  // Operacja atomowa na polu ulotnym:
  public static void cancel() { canceled = true; }
  public Entrance(int id) {
    this.id = id;
    // Zachowanie zadania na licie. Zapobiega usuwaniu
    // zada w ramach odmiecania:
    entrances.add(this);
  }
  public void run() {
    while(!canceled) {
      synchronized(this) {
        ++number;
      }
      print(this + " Razem: " + count.increment());
      try {
        TimeUnit.MILLISECONDS.sleep(100);
      } catch(InterruptedException e) {
        print("przerwano upienie");
      }
    }
    print("Zatrzymywanie: " + this);
  }
  public synchronized int getValue() { return number; }
  public String toString() {
    return "Wejcie " + id + ": " + getValue();
  }
  public static int getTotalCount() {
    return count.value();
  }
  public static int sumEntrances() {
    int sum = 0;
    for(Entrance entrance : entrances)
      sum += entrance.getValue();
    return sum;
  }
}

public class OrnamentalGarden {
  public static void main(String[] args) throws Exception {
    ExecutorService exec = Executors.newCachedThreadPool();
    for(int i = 0; i < 5; i++)
      exec.execute(new Entrance(i));
    // Odczekaj, zatrzymaj zadania i zbierz dane:
    TimeUnit.SECONDS.sleep(3);
    Entrance.cancel();
    exec.shutdown();
    if(!exec.awaitTermination(250, TimeUnit.MILLISECONDS))
      print("Niektre zadania wci dziaaj!");
    print("Razem: " + Entrance.getTotalCount());
    print("Suma wej: " + Entrance.sumEntrances());
  }
} /* Output: (Sample)
Wejcie 0: 1 Razem: 1
Wejcie 2: 1 Razem: 3
Wejcie 1: 1 Razem: 2
Wejcie 4: 1 Razem: 5
Wejcie 3: 1 Razem: 4
Wejcie 2: 2 Razem: 6
Wejcie 4: 2 Razem: 7
Wejcie 0: 2 Razem: 8
...
Wejcie 3: 29 Razem: 143
Wejcie 0: 29 Razem: 144
Wejcie 4: 29 Razem: 145
Wejcie 2: 30 Razem: 147
Wejcie 1: 30 Razem: 146
Wejcie 0: 30 Razem: 149
Wejcie 3: 30 Razem: 148
Wejcie 4: 30 Razem: 150
Zatrzymywanie: Wejcie 2: 30
Zatrzymywanie: Wejcie 1: 30
Zatrzymywanie: Wejcie 0: 30
Zatrzymywanie: Wejcie 3: 30
Zatrzymywanie: Wejcie 4: 30
Razem: 150
Suma wej: 150
*///:~
