//: concurrency/GreenhouseScheduler.java
// Reimplementacja przykadu innerclasses/GreenhouseController.java
// z uyciem wykonawcy ScheduledThreadPoolExecutor.
// {Args: 5000}
import java.util.concurrent.*;
import java.util.*;

public class GreenhouseScheduler {
  private volatile boolean light = false;
  private volatile boolean water = false;
  private String thermostat = "Dzie";
  public synchronized String getThermostat() {
    return thermostat;
  }
  public synchronized void setThermostat(String value) {
    thermostat = value;
  }
  ScheduledThreadPoolExecutor scheduler =
    new ScheduledThreadPoolExecutor(10);
  public void schedule(Runnable event, long delay) {
    scheduler.schedule(event,delay,TimeUnit.MILLISECONDS);
  }
  public void
  repeat(Runnable event, long initialDelay, long period) {
    scheduler.scheduleAtFixedRate(
      event, initialDelay, period, TimeUnit.MILLISECONDS);
  }
  class LightOn implements Runnable {
    public void run() {
      // Tu kod sterujcy urzdzeniami
      // uruchamiajcymi owietlenie.
      System.out.println("Wczanie wiate");
      light = true;
    }
  }
  class LightOff implements Runnable {
    public void run() {
      // Tu kod sterujcy urzdzeniami
      // uruchamiajcymi owietlenie.
      System.out.println("Wyczanie wiate");
      light = false;
    }
  }
  class WaterOn implements Runnable {
    public void run() {
      // Tu kod sterujcy urzdzeniami
      System.out.println("Obieg wody w szklarni wczony");
      water = true;
    }
  }
  class WaterOff implements Runnable {
    public void run() {
      // Tu kod sterujcy urzdzeniami
      System.out.println("Obieg wody w szklarni wyczony");
      water = false;
    }
  }
  class ThermostatNight implements Runnable {
    public void run() {
      // Tu kod sterujcy urzdzeniami
      System.out.println("Termostat przeczony na ustawienie nocne");
      setThermostat("Noc");
    }
  }
  class ThermostatDay implements Runnable {
    public void run() {
      // Tu kod sterujcy urzdzeniami
      System.out.println("Termostat przeczony na ustawienie dzienne");
      setThermostat("Dzie");
    }
  }
  class Bell implements Runnable {
    public void run() { System.out.println("Dzy!"); }
  }
  class Terminate implements Runnable {
    public void run() {
      System.out.println("Wyczanie systemu");
      scheduler.shutdownNow();
      // Trzeba uruchomi osobne zadanie,
      // bo wykonawca-planista zosta zamknity:
      new Thread() {
        public void run() {
          for(DataPoint d : data)
            System.out.println(d);
        }
      }.start();
    }
  }
  // Nowy element: zbieranie danych
  static class DataPoint {
    final Calendar time;
    final float temperature;
    final float humidity;
    public DataPoint(Calendar d, float temp, float hum) {
      time = d;
      temperature = temp;
      humidity = hum;
    }
    public String toString() {
      return time.getTime() +
        String.format(
          " temperatura: %1$.1f wilgotno: %2$.2f",
          temperature, humidity);
    }
  }
  private Calendar lastTime = Calendar.getInstance();
  { // Wyrwnanie daty do p godziny
    lastTime.set(Calendar.MINUTE, 30);
    lastTime.set(Calendar.SECOND, 00);
  }
  private float lastTemp = 18.3f;
  private int tempDirection = +1;
  private float lastHumidity = 50.0f;
  private int humidityDirection = +1;
  private Random rand = new Random(47);
  List<DataPoint> data = Collections.synchronizedList(
    new ArrayList<DataPoint>());
  class CollectData implements Runnable {
    public void run() {
      System.out.println("Zbieranie danych");
      synchronized(GreenhouseScheduler.this) {
        // Udajemy, e interwa jest duszy, ni faktyczny:
        lastTime.set(Calendar.MINUTE,
          lastTime.get(Calendar.MINUTE) + 30);
        // Raz na pi prb odwracamy trend:
        if(rand.nextInt(5) == 4)
          tempDirection = -tempDirection;
        // Zachowanie poprzedniej wartoci:
        lastTemp = lastTemp +
          tempDirection * (0.5f + rand.nextFloat());
        if(rand.nextInt(5) == 4)
          humidityDirection = -humidityDirection;
        lastHumidity = lastHumidity +
          humidityDirection * rand.nextFloat();
        // Obiekt Calendar musi zosta sklonowany, inaczej
        // wszystkie obiekty danych DataPoints bd zawieray
        // referencj tego samego momentu w czasie. W przypadku
	// prostych obiektw, jak Calendar, wystarczy metoda clone().
        data.add(new DataPoint((Calendar)lastTime.clone(),
          lastTemp, lastHumidity));
      }
    }
  }
  public static void main(String[] args) {
    GreenhouseScheduler gh = new GreenhouseScheduler();
    gh.schedule(gh.new Terminate(), 5000);
    // Wczeniejsza klasa "Restart" ju zbdna:
    gh.repeat(gh.new Bell(), 0, 1000);
    gh.repeat(gh.new ThermostatNight(), 0, 2000);
    gh.repeat(gh.new LightOn(), 0, 200);
    gh.repeat(gh.new LightOff(), 0, 400);
    gh.repeat(gh.new WaterOn(), 0, 600);
    gh.repeat(gh.new WaterOff(), 0, 800);
    gh.repeat(gh.new ThermostatDay(), 0, 1400);
    gh.repeat(gh.new CollectData(), 500, 500);
  }
} /* (Execute to see output) *///:~
