//: concurrency/Daemons.java
// Wtki-demony wytwarzaj kolejne demony.
import java.util.concurrent.*;
import static net.mindview.util.Print.*;

class Daemon implements Runnable {
  private Thread[] t = new Thread[10];
  public void run() {
    for(int i = 0; i < t.length; i++) {
      t[i] = new Thread(new DaemonSpawn());
      t[i].start();
      printnb("uruchomiono wtek DaemonSpawn " + i + ", ");
    }
    for(int i = 0; i < t.length; i++)
      printnb("t[" + i + "].isDaemon() = " +
        t[i].isDaemon() + ", ");
    while(true)
      Thread.yield();
  }
}

class DaemonSpawn implements Runnable {
  public void run() {
    while(true)
      Thread.yield();
  }
}

public class Daemons {
  public static void main(String[] args) throws Exception {
    Thread d = new Thread(new Daemon());
    d.setDaemon(true);
    d.start();
    printnb("d.isDaemon() = " + d.isDaemon() + ", ");
    // Umoliwiamy w wtkach-demonach zakoczenie
    // ich procesw startowych:
    TimeUnit.SECONDS.sleep(1);
  }
} /* Output: (Sample)
d.isDaemon() = true, uruchomiono wtek DaemonSpawn 0, uruchomiono wtek DaemonSpawn 1, uruchomiono wtek DaemonSpawn 2, uruchomiono wtek DaemonSpawn 3, uruchomiono wtek DaemonSpawn 4, uruchomiono wtek DaemonSpawn 5, uruchomiono wtek DaemonSpawn 6, uruchomiono wtek DaemonSpawn 7, uruchomiono wtek DaemonSpawn 8, uruchomiono wtek DaemonSpawn 9, t[0].isDaemon() = true, t[1].isDaemon() = true, t[2].isDaemon() = true, t[3].isDaemon() = true, t[4].isDaemon() = true, t[5].isDaemon() = true, t[6].isDaemon() = true, t[7].isDaemon() = true, t[8].isDaemon() = true, t[9].isDaemon() = true,
*///:~
