//: concurrency/CloseResource.java
// Przerywanie zablokowanego zadania
// przez zamykanie zasobu.
// {RunByHand}
import java.net.*;
import java.util.concurrent.*;
import java.io.*;
import static net.mindview.util.Print.*;

public class CloseResource {
  public static void main(String[] args) throws Exception {
    ExecutorService exec = Executors.newCachedThreadPool();
    ServerSocket server = new ServerSocket(8080);
    InputStream socketInput =
      new Socket("localhost", 8080).getInputStream();
    exec.execute(new IOBlocked(socketInput));
    exec.execute(new IOBlocked(System.in));
    TimeUnit.MILLISECONDS.sleep(100);
    print("Zamykanie wszystkich wtkw");
    exec.shutdownNow();
    TimeUnit.SECONDS.sleep(1);
    print("Zamykanie " + socketInput.getClass().getName());
    socketInput.close(); // Zwolnienie zablokowanego wtku
    TimeUnit.SECONDS.sleep(1);
    print("Zamykanie " + System.in.getClass().getName());
    System.in.close(); // Zwolnienie zablokowanego wtku
  }
} /* Output: (85% match)
Oczekiwanie na read():
Oczekiwanie na read():
Zamykanie wszystkich wtkw
Zamykanie java.net.SocketInputStream
Przerwany w zawieszeniu na operacji wejcia-wyjcia
Opuszczanie metody IOBlocked.run()
Zamykanie java.io.BufferedInputStream
Opuszczanie metody IOBlocked.run()
*///:~
