//: concurrency/CallableDemo.java
import java.util.concurrent.*;
import java.util.*;

class TaskWithResult implements Callable<String> {
  private int id;
  public TaskWithResult(int id) {
    this.id = id;
  }
  public String call() {
    return "Wynik wywoania TaskWithResult " + id;
  }
}

public class CallableDemo {
  public static void main(String[] args) {
    ExecutorService exec = Executors.newCachedThreadPool();
    ArrayList<Future<String>> results =
      new ArrayList<Future<String>>();
    for(int i = 0; i < 10; i++)
      results.add(exec.submit(new TaskWithResult(i)));
    for(Future<String> fs : results)
      try {
        // Wywoanie get() blokuje wywoujcego:
        System.out.println(fs.get());
      } catch(InterruptedException e) {
        System.out.println(e);
        return;
      } catch(ExecutionException e) {
        System.out.println(e);
      } finally {
        exec.shutdown();
      }
  }
} /* Output:
Wynik wywoania TaskWithResult 0
Wynik wywoania TaskWithResult 1
Wynik wywoania TaskWithResult 2
Wynik wywoania TaskWithResult 3
Wynik wywoania TaskWithResult 4
Wynik wywoania TaskWithResult 5
Wynik wywoania TaskWithResult 6
Wynik wywoania TaskWithResult 7
Wynik wywoania TaskWithResult 8
Wynik wywoania TaskWithResult 9
*///:~
