//: arrays/ArrayOptions.java
// Inicjalizacja i przypisywanie tablic.
import java.util.*;
import static net.mindview.util.Print.*;

public class ArrayOptions {
  public static void main(String[] args) {
    BerylliumSphere[] a; // Lokalna zmienna niezainicjalizowana
    BerylliumSphere[] b = new BerylliumSphere[5];
    // Referencje w tablicy s automatycznie
    // inicjalizowane wartociami pustymi (null):
    print("b: " + Arrays.toString(b));
    BerylliumSphere[] c = new BerylliumSphere[4];
    for(int i = 0; i < c.length; i++)
      if(c[i] == null) // test na obecno referencji pustej
        c[i] = new BerylliumSphere();
    // Inicjalizacja agregatowa:
    BerylliumSphere[] d = { new BerylliumSphere(),
      new BerylliumSphere(), new BerylliumSphere()
    };
    // Dynamiczna inicjalizacja agregatowa:
    a = new BerylliumSphere[]{
      new BerylliumSphere(), new BerylliumSphere(),
    };
    // (W obu porzypadkach przecinek za ostatnim
    // inicjalizatorem jest opcjonalny)
    print("a.length = " + a.length);
    print("b.length = " + b.length);
    print("c.length = " + c.length);
    print("d.length = " + d.length);
    a = d;
    print("a.length = " + a.length);

    // Tablice wartoci elementarnych:
    int[] e; // Referencja pusta
    int[] f = new int[5];
    // Wartoci elementarne w tablicy s automatycznie
    // inicjalizowane zerem:
    print("f: " + Arrays.toString(f));
    int[] g = new int[4];
    for(int i = 0; i < g.length; i++)
      g[i] = i*i;
    int[] h = { 11, 47, 93 };
    // Bd kompilacji: niezainicjalizowana zmienna e:
    //!print("e.length = " + e.length);
    print("f.length = " + f.length);
    print("g.length = " + g.length);
    print("h.length = " + h.length);
    e = h;
    print("e.length = " + e.length);
    e = new int[]{ 1, 2 };
    print("e.length = " + e.length);
  }
} /* Output:
b: [null, null, null, null, null]
a.length = 2
b.length = 5
c.length = 4
d.length = 3
a.length = 3
f: [0, 0, 0, 0, 0]
f.length = 5
g.length = 4
h.length = 3
e.length = 3
e.length = 2
*///:~
